//------------------------------------------------------------------------------
// File: VisitJail.cs
// State node that is used to visit nearest building of specified type (string 
// variable "targetbldg")
//------------------------------------------------------------------------------

////////////////////////////////////////////////////////////////////////////////
//! Called when node is entered
//! \param %cmpAI AI component object
////////////////////////////////////////////////////////////////////////////////
function AISMN_VisitBuilding::OnEnter(%this, %cmpAI)
{
   // If a path is successfully set to the building then
   %building = GetStringVariable(%cmpAI, "targetbldg");
   if(SetPathForNearestTeamBuilding(%cmpAI, %building, $OST_PLAYER)) {
      // Get the object and the character component
      %object  = GetThisObject(%cmpAI);
      %cmpChar = slgQueryInterface(%object, $CID_CHARACTER);
      
      // If drunk then      
      if(%cmpChar.inState($CharacterState::Drunk)) {
         // Set reform state
         %cmpChar.setState($CharacterState::Reform);
         
         // Play drunk walk animation
         %object.playThread(0, "drunkwalk");
      }
      
      // Normal
      else {
         %object.playThread(0, "run");
      }
   }
	
	return;
}

////////////////////////////////////////////////////////////////////////////////
//! Called when node is exited
//! \param %cmpAI AI component object
////////////////////////////////////////////////////////////////////////////////
function AISMN_VisitBuilding::OnExit(%this, %cmpAI)
{
   %object  = GetThisObject(%cmpAI);
   
   // Reached building, play root animation
   %object.playThread(0, "root");
}

////////////////////////////////////////////////////////////////////////////////
//! Called when node is updated
//! \param %cmpAI AI component object
////////////////////////////////////////////////////////////////////////////////
function AISMN_VisitBuilding::Update(%this, %cmpAI)
{
   // If through following the path then we are done
   if(!IsFollowingPath(%cmpAI)) {
      ReturnValue(%cmpAI, 0);
   }
   // Remain in state
   else {
      ReturnValue(%cmpAI, -1);
   }
   return;
}

// End VisitJail.cs